#include <iostream>
#include <vector>
#include <algorithm>
#include <set>

using namespace std;

class Graph {
private:
    int N; 
    vector<vector<int>> adjList; 

public:
    Graph(int N) : N(N) {
        adjList.resize(N);
    }

    void addEdge(int u, int v) {
        adjList[u].push_back(v);
        adjList[v].push_back(u); 
    }

    void findAllPaths(int start, int end, vector<int>& path, set<vector<int>>& allPaths) {
        path.push_back(start);
        if (start == end) {
            allPaths.insert(path);
        } else {
            for (int neighbor : adjList[start]) {
                if (find(path.begin(), path.end(), neighbor) == path.end()) {
                    findAllPaths(neighbor, end, path, allPaths);
                }
            }
        }
        path.pop_back();
    }

    double findMedian(const vector<int>& values) {
        vector<int> sortedValues = values;
        sort(sortedValues.begin(), sortedValues.end());
        int n = sortedValues.size();
        if (n % 2 == 1) {
            return sortedValues[n / 2];
        } else {
            return (sortedValues[n / 2 - 1] + sortedValues[n / 2]) / 2.0;
        }
    }
};

int main() {
    int N, M, Q, P;
    cin >> N >> M >> Q >> P;

    vector<int> A(N);
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }

    Graph g(N);
    for (int i = 0; i < M; ++i) {
        int u, v;
        cin >> u >> v;
        g.addEdge(u - 1, v - 1); 
    }

    vector<int> ans(Q, 0);
    for (int i = 0; i < Q; ++i) {
        int a1, b1;
        cin >> a1 >> b1;
        int a = (a1 + ans[i] * P - 1) % N;
        int b = (b1 + ans[i] * P - 1) % N;

        set<vector<int>> allPaths;
        vector<int> path;
        g.findAllPaths(a, b, path, allPaths);

        vector<int> values;
        for (const auto& p : allPaths) {
            for (int node : p) {
                values.push_back(A[node]);
            }
        }

        ans[i] = g.findMedian(values);
        cout << ans[i] << endl;
    }

    return 0;
}